/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.tn3270e;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.IPInput;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.ras.RAS;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class Tn3270eAddressInput
extends Panel
implements JDMInput,
ItemListener {
    private static final int RASID = 19;
    private static final int RASSUB = 1041;
    private static final String Type_none = "None";
    private static final String Type_IPV4 = "IPV4";
    private static final String Type_IPV6 = "IPV6";
    private static final String Type_invalid = "Invalid";
    private static final int Type_none_index = 0;
    private static final int Type_IPV4_index = 1;
    private static final int Type_IPV6_index = 2;
    private static final int Type_invalid_index = 3;
    private static final String[] Tn3270eAddressTypes = new String[]{"None", "IPV4", "IPV6"};
    private static final String NlsBundleName = "ibm.nways.tn3270e.Tn3270eAddressResources";
    private static ResourceBundle nlsResources = null;
    protected Label typeLabel;
    protected Choice typeChoice;
    protected Label ipV6Label;
    protected HexInput ipV6Prefix;
    protected Label ipV4Label;
    protected IPInput ipV4Part;
    boolean hasError = false;

    public Tn3270eAddressInput() {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "Tn3270eAddressInput");
        }
        this.typeLabel = new Label(Tn3270eAddressInput.getNLSString("TypeLabel"));
        this.typeChoice = new Choice();
        int n = 0;
        while (n < Tn3270eAddressTypes.length) {
            this.typeChoice.add(Tn3270eAddressInput.getNLSString(Tn3270eAddressTypes[n]));
            ++n;
        }
        this.typeChoice.addItemListener(this);
        this.ipV6Label = new Label(Tn3270eAddressInput.getNLSString("IPV6Label"));
        this.ipV6Prefix = new HexInput("", 12, 24);
        this.ipV4Label = new Label(Tn3270eAddressInput.getNLSString("IPV4Label"));
        this.ipV4Part = new IPInput();
        this.typeLabel.setForeground(JmaColors.textText);
        this.ipV6Label.setForeground(JmaColors.textText);
        this.ipV4Label.setForeground(JmaColors.textText);
        this.typeChoice.setForeground(JmaColors.textText);
        this.ipV6Prefix.setForeground(JmaColors.textText);
        this.ipV4Part.setForeground(JmaColors.textText);
        this.typeChoice.setBackground(JmaColors.background);
        this.ipV6Prefix.setBackground(JmaColors.background);
        this.ipV4Part.setBackground(JmaColors.background);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.typeLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.ipV6Label, gridBagConstraints);
        gridBagLayout.setConstraints(this.ipV4Label, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagLayout.setConstraints(this.typeChoice, gridBagConstraints2);
        gridBagLayout.setConstraints((Component)this.ipV6Prefix, gridBagConstraints2);
        gridBagLayout.setConstraints((Component)this.ipV4Part, gridBagConstraints2);
        this.add(this.typeLabel);
        this.add(this.typeChoice);
        this.add(this.ipV6Label);
        this.add((Component)this.ipV6Prefix);
        this.add(this.ipV4Label);
        this.add((Component)this.ipV4Part);
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "Tn3270eAddressInput");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "itemStateChanged");
        }
        if ((n = this.typeChoice.getSelectedIndex()) != 3 && this.hasError) {
            this.typeChoice.remove(3);
            this.hasError = false;
        }
        if (n == 0) {
            this.ipV6Prefix.setValue("");
            this.ipV6Prefix.setEditable(false);
            this.ipV4Part.setValue("");
            this.ipV4Part.setEditable(false);
        } else if (n == 1) {
            this.ipV6Prefix.setValue("");
            this.ipV6Prefix.setEditable(false);
            this.ipV4Part.setEditable(true);
        } else if (n == 2) {
            this.ipV6Prefix.setEditable(true);
            this.ipV4Part.setEditable(true);
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "itemStateChanged");
        }
    }

    public void setValue(Object object) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "setValue(Object)");
        }
        if (object instanceof OctetString) {
            this.parseInput((OctetString)object);
        } else {
            this.setErrorValue(object.toString());
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "setValue(Object)");
        }
    }

    public void setValue(String string) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "setValue(String)");
        }
        try {
            OctetString octetString = new OctetString(string);
            this.setValue(octetString);
        }
        catch (Exception exception) {
            this.setErrorValue(string.toString());
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "setValue(String)");
        }
    }

    public Object getValue() {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "getValue");
        }
        OctetString octetString = null;
        int n = this.typeChoice.getSelectedIndex();
        if (n == 0) {
            octetString = new OctetString("");
        } else if (n == 1) {
            IPAddress iPAddress = (IPAddress)this.ipV4Part.getValue();
            octetString = new OctetString(iPAddress.getBytes());
        } else if (n == 2) {
            byte[] byArray = new byte[16];
            int n2 = 0;
            OctetString octetString2 = (OctetString)this.ipV6Prefix.getValue();
            int n3 = octetString2.value.length > 12 ? 12 : octetString2.value.length;
            int n4 = 0;
            while (n4 < n3) {
                byArray[n2] = octetString2.value[n4];
                ++n2;
                ++n4;
            }
            while (n2 < 12) {
                byArray[n2] = 0;
                ++n2;
            }
            byte[] byArray2 = ((IPAddress)this.ipV4Part.getValue()).getBytes();
            int n5 = 0;
            while (n5 < 4) {
                byArray[n2] = byArray2[n5];
                ++n2;
                ++n5;
            }
            octetString = new OctetString(byArray);
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "getValue");
        }
        return octetString;
    }

    public String toString() {
        return this.getValue().toString();
    }

    public boolean isValidValue() {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "isValidValue");
        }
        boolean bl = false;
        int n = this.typeChoice.getSelectedIndex();
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            bl = this.ipV4Part.isValidValue();
        } else if (n == 2) {
            if (this.ipV6Prefix.isValidValue()) {
                OctetString octetString = (OctetString)this.ipV6Prefix.getValue();
                bl = octetString.value.length == 12 ? this.ipV4Part.isValidValue() : false;
            } else {
                bl = false;
            }
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "isValidValue");
        }
        return bl;
    }

    public boolean ignoreValue() {
        if (RAS.isEnabled(19, 1041)) {
            RAS.trace(19, 1041, this, "ignoreValue", "ignoreValue");
        }
        return false;
    }

    private void setErrorValue(String string) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "ignoreValue");
        }
        if (!this.hasError) {
            this.typeChoice.add(Tn3270eAddressInput.getNLSString(Type_invalid));
            this.hasError = true;
        }
        this.typeChoice.select(3);
        this.ipV6Prefix.setValue(string);
        this.ipV6Prefix.setEditable(false);
        this.ipV4Part.setValue("");
        this.ipV4Part.setEditable(false);
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "ignoreValue");
        }
    }

    private void parseInput(OctetString octetString) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "parseInput");
        }
        if (this.hasError) {
            this.typeChoice.remove(3);
            this.hasError = false;
        }
        if (octetString.toString().equals("")) {
            this.typeChoice.select(0);
            this.ipV6Prefix.setValue("");
            this.ipV6Prefix.setEditable(false);
            this.ipV4Part.setValue("");
            this.ipV4Part.setEditable(false);
        } else if (octetString.value.length == 4) {
            this.typeChoice.select(1);
            this.ipV6Prefix.setValue("");
            this.ipV6Prefix.setEditable(false);
            IPAddress iPAddress = new IPAddress(octetString.value, 0);
            this.ipV4Part.setValue((Object)iPAddress);
            this.ipV4Part.setEditable(true);
        } else if (octetString.value.length == 16) {
            this.typeChoice.select(2);
            String string = octetString.toString().substring(0, 24);
            this.ipV6Prefix.setValue((Object)new OctetString(string));
            this.ipV6Prefix.setEditable(true);
            IPAddress iPAddress = new IPAddress(octetString.value, 12);
            this.ipV4Part.setValue((Object)iPAddress);
            this.ipV4Part.setEditable(true);
        } else {
            this.setErrorValue(octetString.toString());
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "parseInput");
        }
    }

    protected static String getNLSString(String string) {
        try {
            if (nlsResources == null) {
                nlsResources = ResourceBundle.getBundle(NlsBundleName);
            }
            if (nlsResources == null) {
                return string;
            }
            return nlsResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

